# -*-coding:utf-8-*-
# pylint: disable=E1101,R,C
import numpy as np
import torch.nn as nn
import torch.nn.functional as F
import torch
import torch.utils.data as data_utils
import gzip
import pickle
import numpy as np
from torch.autograd import Variable
import torchvision
import torchvision.transforms as transforms
import torchvision.models as models
import matplotlib.pyplot as plt
from compact_bilinear_pooling import CountSketch, CompactBilinearPooling

DEVICE = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")

NUM_EPOCHS = 20
BATCH_SIZE = 64
LEARNING_RATE = 1e-3

pretrained_model=''


def loadtraindata():
    path = "/images/train"
    trainset = torchvision.datasets.ImageFolder(path,
                                                transform=transforms.Compose([
                                                    transforms.Resize((224, 224)), 

                                                    transforms.CenterCrop(224),
                                                    transforms.ToTensor()])
                                                )

    trainloader = torch.utils.data.DataLoader(trainset, batch_size=BATCH_SIZE,
                                              shuffle=True, num_workers=0)
    return trainset,trainloader


def conv3x3(in_planes, out_planes, stride=1):
    """3x3 convolution with padding"""
    return nn.Conv2d(in_planes, out_planes, kernel_size=3, stride=stride,
                     padding=1, bias=False)


def conv1x1(in_planes, out_planes, stride=1):
    """1x1 convolution"""
    return nn.Conv2d(in_planes, out_planes, kernel_size=1, stride=stride, bias=False)


class BasicBlock(nn.Module):
    expansion = 1

    def __init__(self, inplanes, planes, stride=1, downsample=None):
        super(BasicBlock, self).__init__()
        self.conv1 = conv3x3(inplanes, planes, stride)
        self.bn1 = nn.BatchNorm2d(planes)
        self.relu = nn.ReLU(inplace=True)
        self.conv2 = conv3x3(planes, planes)
        self.bn2 = nn.BatchNorm2d(planes)
        self.downsample = downsample
        self.stride = stride


    def forward(self, x):
        identity = x

        out = self.conv1(x)
        out = self.bn1(out)
        out = self.relu(out)

        out = self.conv2(out)
        out = self.bn2(out)

        if self.downsample is not None:
            identity = self.downsample(x)

        out += identity
        out = self.relu(out)

        return out


class Bottleneck(nn.Module):
    expansion = 4

    def __init__(self, inplanes, planes, stride=1, downsample=None):
        super(Bottleneck, self).__init__()
        self.conv1 = conv1x1(inplanes, planes)
        self.bn1 = nn.BatchNorm2d(planes)
        self.conv2 = conv3x3(planes, planes, stride)
        self.bn2 = nn.BatchNorm2d(planes)
        self.conv3 = conv1x1(planes, planes * self.expansion)
        self.bn3 = nn.BatchNorm2d(planes * self.expansion)
        self.relu = nn.ReLU(inplace=True)
        self.downsample = downsample
        self.stride = stride

    def forward(self, x):
        identity = x

        out = self.conv1(x)
        out = self.bn1(out)
        out = self.relu(out)

        out = self.conv2(out)
        out = self.bn2(out)
        out = self.relu(out)

        out = self.conv3(out)
        out = self.bn3(out)

        if self.downsample is not None:
            identity = self.downsample(x)

        out += identity
        out = self.relu(out)

        return out


class ResNet(nn.Module):

    def __init__(self, block, layers, num_classes=38, zero_init_residual=False):
        super(ResNet, self).__init__()

        self.inplanes = 64
        self.conv1 = nn.Conv2d(3, 64, kernel_size=7, stride=2, padding=3,bias=False)
        self.bn1 = nn.BatchNorm2d(64)
        self.relu = nn.ReLU(inplace=True)
        self.maxpool = nn.MaxPool2d(kernel_size=3, stride=2, padding=1)
        self.layer1 = self._make_layer(block, 64, layers[0])
        self.layer2 = self._make_layer(block, 128, layers[1], stride=2)
        self.layer3 = self._make_layer(block, 256, layers[2], stride=2)

        for p in self.parameters():
            p.requires_grad = False

        self.layer4 = self._make_layer(block, 512, layers[3], stride=2)

        self.input_size = 512
        self.f_output = 4096
        self.output_size = 8192
        self.mcb = CompactBilinearPooling(self.input_size, self.input_size, self.output_size).cuda()

        self.avgpool = nn.AdaptiveAvgPool2d((1, 1))          
        self.fc1 = nn.Linear(self.output_size * block.expansion, self.f_output)
        self.fc2 = nn.Linear(self.f_output, num_classes)


        for m in self.modules():
            if isinstance(m, nn.Conv2d):
                nn.init.kaiming_normal_(m.weight, mode='fan_out', nonlinearity='relu')
            elif isinstance(m, nn.BatchNorm2d):
                nn.init.constant_(m.weight, 1)
                nn.init.constant_(m.bias, 0)


        if zero_init_residual:
            for m in self.modules():
                if isinstance(m, Bottleneck):
                    nn.init.constant_(m.bn3.weight, 0)
                elif isinstance(m, BasicBlock):
                    nn.init.constant_(m.bn2.weight, 0)

    def _make_layer(self, block, planes, blocks, stride=1):
        downsample = None
        if stride != 1 or self.inplanes != planes * block.expansion:
            downsample = nn.Sequential(
                conv1x1(self.inplanes, planes * block.expansion, stride),
                nn.BatchNorm2d(planes * block.expansion),
            )

        layers = []
        layers.append(block(self.inplanes, planes, stride, downsample))
        self.inplanes = planes * block.expansion
        for _ in range(1, blocks):
            layers.append(block(self.inplanes, planes))

        return nn.Sequential(*layers)

    def signed_sqrt(self,x):
        y = torch.sqrt(F.relu(x)) - torch.sqrt(F.relu(-x))
        return y

    def forward(self, x):
        x = self.conv1(x)
        x = self.bn1(x)
        x = self.relu(x)
        x = self.maxpool(x)

        x = self.layer1(x)
        x = self.layer2(x)
        x = self.layer3(x)
        x = self.layer4(x)

        # print x
        pool5 = x.permute(0, 2, 3, 1)
        print pool5.size()
        bilinear = self.mcb(pool5, pool5)
        print bilinear.size()
        bilinear = bilinear.permute(0, 3, 1, 2)
        print bilinear.size()
        poolB = F.max_pool2d(bilinear, 7, 7)
        print poolB.size()
        poolB = poolB.view(poolB.shape[0], -1)
        print poolB.size()
        signed_sqrt = self.signed_sqrt(poolB)
        L2 = F.normalize(signed_sqrt, p=2, dim=1)
        
        x = self.fc1(L2)
        x = self.fc2(x)
        return x

def resnet34(pretrained=False, **kwargs):
    """Constructs a ResNet-34 model.
    Args:
        pretrained (bool): If True, returns a model pre-trained on ImageNet
    """
    model = ResNet(BasicBlock, [3, 4, 6, 3], **kwargs)
    return model


def main():



    train_dataset,train_loader = loadtraindata()

    classifier = resnet34()

    state_dict=torch.load(pretrained_model)
    model_dict=classifier.state_dict()
    pretrained_dict=state_dict
    pretrained_dict=({k: v for k, v in pretrained_dict.items() if k in model_dict})
    model_dict.update(pretrained_dict)
    classifier.load_state_dict(model_dict)
    print("",classifier)
    classifier.to(DEVICE)

    print("#params", sum([x.numel() for x in classifier.parameters()]))


    criterion = nn.CrossEntropyLoss()
    criterion = criterion.to(DEVICE)

    params=filter(lambda p: p.requires_grad, classifier.parameters())
    optimizer = torch.optim.Adam(params,lr=LEARNING_RATE)
    scheduler = torch.optim.lr_scheduler.StepLR(optimizer, step_size=15, gamma=0.1)

    for epoch in range(NUM_EPOCHS):
        scheduler.step()
        print scheduler.get_lr()[0]

        for i, data in enumerate(train_loader):
            classifier.train()

            images, labels = data
   
            images = images.to(DEVICE)
            labels = labels.to(DEVICE)


            optimizer.zero_grad()
            outputs = classifier(images)
            loss = criterion(outputs, labels)
            loss.backward()

            optimizer.step()

            print('\rEpoch [{0}/{1}], Iter [{2}/{3}] Loss: {4:.4f}'.format(
                epoch+1, NUM_EPOCHS, i+1, len(train_dataset)//BATCH_SIZE,
                loss.item()))
            # params = classifier.state_dict()
            # for k, v in params.items():
            #     print(k)  
            # print(params['layer3.5.bn2.weight'])  
            # print(params['layer4.0.conv1.weight'])  

        print("")
        # /78
    # torch.save(classifier, 'net.pkl')  
    torch.save(classifier.state_dict(), 'net_params.pkl')  



if __name__ == '__main__':
    main()
