# -*-coding:utf-8-*-
# pylint: disable=E1101,R,C
import numpy as np
import torch.nn as nn
import torch.nn.functional as F
import torch
import torch.utils.data as data_utils
import gzip
import pickle
import numpy as np
from torch.autograd import Variable
import torchvision
import torchvision.transforms as transforms
import torchvision.models as models
import matplotlib.pyplot as plt
from compact_bilinear_pooling import CountSketch, CompactBilinearPooling

DEVICE = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")

NUM_EPOCHS = 20
BATCH_SIZE = 64
LEARNING_RATE = 1e-4

pretrained_model=''


def loadtraindata():
    path = "/images/train"
    trainset = torchvision.datasets.ImageFolder(path,
                                                transform=transforms.Compose([
                                                    transforms.Resize((224, 224)),  

                                                    transforms.CenterCrop(224),
                                                    transforms.ToTensor()])
                                                )

    trainloader = torch.utils.data.DataLoader(trainset, batch_size=BATCH_SIZE,
                                              shuffle=True, num_workers=0)
    return trainset,trainloader




class MyClassifier(nn.Module):

    def __init__(self):
        super(MyClassifier, self).__init__()
        self.f_output=4096
        self.class_num = 38
        self.input_size = 512
        self.output_size = 8192
        self._layers={}
        self._init_head_tail()
        self.mcb = CompactBilinearPooling(self.input_size, self.input_size, self.output_size).cuda()
        self.fc7 = nn.Linear(self.output_size, self.f_output)
        self.fc8=nn.Linear(self.f_output, self.class_num)

    def signed_sqrt(self,x):
        y = torch.sqrt(F.relu(x)) - torch.sqrt(F.relu(-x))
        return y

    def _init_head_tail(self):
     self.vgg = models.vgg16()

     # Fix the layers before conv5:
     for layer in range(24):
      for p in self.vgg.features[layer].parameters(): p.requires_grad = False

     # not using the last maxpool layer
     self._layers['head'] = nn.Sequential(*list(self.vgg.features._modules.values())[:-1])

    def _image_to_head(self):
     net_conv = self._layers['head'](self.x)

     return net_conv

    def _head_to_tail(self, pool5):
     pool5 = pool5.permute(0, 2, 3, 1)
     bilinear = self.mcb(pool5, pool5)
     bilinear = bilinear.permute(0, 3, 1, 2)
     poolB = F.max_pool2d(bilinear, 14, 14)
     poolB = poolB.view(poolB.shape[0], -1)
     signed_sqrt=self.signed_sqrt(poolB)
     L2 = F.normalize(signed_sqrt,p=2,dim=1)
     return L2

    def load_pretrained_cnn(self, state_dict):
     self.vgg.load_state_dict({k:v for k,v in state_dict.items() if k in self.vgg.state_dict()})

    def forward(self, x):
        self.x=x
        x=self._image_to_head()
        x=self._head_to_tail(x)
        x = self.fc7(x)

        x = self.fc8(x)
        return x
def main():

 
    train_dataset,train_loader = loadtraindata()

    classifier = MyClassifier()

    state_dict=torch.load(pretrained_model)
    model_dict=classifier.state_dict()
    pretrained_dict=state_dict
    pretrained_dict=({k: v for k, v in pretrained_dict.items() if k in model_dict})
    model_dict.update(pretrained_dict)
    classifier.load_state_dict(model_dict)

    print("",classifier)
    classifier.to(DEVICE)
    print("#params", sum([x.numel() for x in classifier.parameters()]))

    # params = classifier.state_dict()
    # for k, v in params.items():
    #     print(k)  

    criterion = nn.CrossEntropyLoss()
    criterion = criterion.to(DEVICE)


    optimizer = torch.optim.Adam(
        # classifier.parameters(),
        filter(lambda p: p.requires_grad, classifier.parameters()),
        lr=LEARNING_RATE)
    #scheduler = torch.optim.lr_scheduler.StepLR(optimizer, step_size=15, gamma=0.1)

    for epoch in range(NUM_EPOCHS):
        for i, data in enumerate(train_loader,0):
            #scheduler.step()
            # print scheduler.get_lr()[0]
            classifier.train()

            images, labels = data
  
            images = images.to(DEVICE)
            labels = labels.to(DEVICE)



            optimizer.zero_grad()
            outputs = classifier(images)
            loss = criterion(outputs, labels)
            loss.backward()

            optimizer.step()

            print('\rEpoch [{0}/{1}], Iter [{2}/{3}] Loss: {4:.4f}'.format(
                epoch+1, NUM_EPOCHS, i+1, len(train_dataset)//BATCH_SIZE,
                loss.item()))
        print("")


    # torch.save(classifier, 'net.pkl')  
    torch.save(classifier.state_dict(), 'net_params.pkl')  



if __name__ == '__main__':
    main()
