import os
import numpy as np


def make_datalist(data_fd, data_list):
    filename_all = os.listdir(data_fd)
    filename_all = [data_fd+'/'+filename+'\n' for filename in filename_all if filename.endswith('.tfrecords')]

    np.random.shuffle(filename_all)
    np.random.shuffle(filename_all)
    with open(data_list, 'w') as fp:
        fp.writelines(filename_all)

def make_datalist_val(data_fd, data_list):
    filename_all = os.listdir(data_fd)
    # sort
    filename_all.sort(key=lambda x:int(x[1:-10]))
    filename_all = [data_fd+'/'+filename+'\n' for filename in filename_all if filename.endswith('.tfrecords')]

    with open(data_list, 'w') as fp:
        fp.writelines(filename_all)


if __name__ == '__main__':
    data_fd = './data/Potsdam_test/'
    data_list = './data/datalist/Potsdam_test.txt'

    make_datalist_val(data_fd, data_list)
