import tensorflow as tf
from tensorflow import keras


def cycle_consistency_loss(real_images, generated_images):
    """
    Compute the cycle consistency loss.
    """
    return tf.reduce_mean(tf.abs(real_images - generated_images))


def lsgan_loss_generator(prob_fake_is_real):
    """
    Computes the LS-GAN loss as minimized by the generator.
    """
    return tf.reduce_mean(tf.squared_difference(prob_fake_is_real, 1))


def lsgan_loss_discriminator(prob_real_is_real, prob_fake_is_real):
    """
    Computes the LS-GAN loss as minimized by the discriminator.
    """
    return (tf.reduce_mean(tf.squared_difference(prob_real_is_real, 1)) +
            tf.reduce_mean(tf.squared_difference(prob_fake_is_real, 0))) * 0.5

def _softmax_loss(logits,gt):
    softmaxloss = keras.losses.categorical_crossentropy(y_true=gt, y_pred=logits)
    return tf.reduce_mean(softmaxloss)

def _softmax_losses(logits,gt):
    softmaxloss = tf.nn.softmax_cross_entropy_with_logits(labels=gt, logits=logits)
    return tf.reduce_mean(softmaxloss)


