# coding=utf-8
import tensorflow as tf
from PIL import Image
import matplotlib.pyplot as plt
import glob
import os
from os.path import join
import tensorflow as tf
import numpy as np
import os
import cv2

curr_path = './data/Potsdam_resize/'
output_path = './data/Potsdam_resize_train/'

imgs = glob.glob(curr_path + 'img/*.TIF')
print(len(imgs))
for imgname in imgs:
    midname = os.path.basename(imgname)[:-4]
    img = Image.open(imgname)
    img = np.asarray(img).astype('float32')
    img = img/127.5-1.0
    data_vol = img.tobytes()

    label = Image.open(curr_path + 'label/' + midname + '.PNG').convert('L')
    label = np.asarray(label).astype('float32')
    label_vol = label.tobytes()
    writer = tf.python_io.TFRecordWriter(output_path + midname +'.tfrecords')
    example = tf.train.Example(features=tf.train.Features(feature={
        'dsize_dim0': tf.train.Feature(int64_list=tf.train.Int64List(value=[256])), 
        'dsize_dim1': tf.train.Feature(int64_list=tf.train.Int64List(value=[256])), 
        'dsize_dim2': tf.train.Feature(int64_list=tf.train.Int64List(value=[3])), 
        'lsize_dim0': tf.train.Feature(int64_list=tf.train.Int64List(value=[256])),  
        'lsize_dim1': tf.train.Feature(int64_list=tf.train.Int64List(value=[256])),  
        'lsize_dim2': tf.train.Feature(int64_list=tf.train.Int64List(value=[1])),  
        'data_vol': tf.train.Feature(bytes_list=tf.train.BytesList(value=[data_vol])),
        'label_vol': tf.train.Feature(bytes_list=tf.train.BytesList(value=[label_vol]))
    }))
    writer.write(example.SerializeToString())
    writer.close()